if GetLocale()~='zhCN' then return end
-- thanks to Whitetooth (author of RatingBuster)
local M = MerInspect

function M:GetRatingInPercent(effect, value, level)
	if not self.base[effect] or not value or not level then return 0 end
	if level < 60 then
		return value / (self.base[effect] * ((level >= 10 and level or 10) - 8) / 52);
	elseif level < 70 then
		return value / (self.base[effect] * 82 / (262 - 3 * level));
	else
		return value / (self.base[effect] * (level + 12) / 52);
	end
end

function M:GetPercentInRating(effect, value, level)		
	if not value or not level then return 0 end
	
	self.base[effect] = self.base[effect] or 0;
	value = value * 100;
	if level < 60 then
		return value * (self.base[effect] * ((level >= 10 and level or 10) - 8) / 52);
	elseif level < 70 then
		return value * (self.base[effect] * 82 / (262 - 3 * level));
	else
		return value * (self.base[effect] * (level + 12) / 52);
	end
end

M.Class2Id = {
	["WARRIOR"] = 1, 
	["PALADIN"] = 2, 
	["HUNTER"] = 3, 
	["ROGUE"] = 4, 
	["PRIEST"] = 5,
	["DEATHKNINGHT"] = 6,
	["SHAMAN"] = 7, 
	["MAGE"] = 8, 
	["WARLOCK"] = 9, 
	["DRUID"] = 10,	
};

M.base = {
	HasteMelee = 10, HasteSpell = 10, HitRating = 10, SpellHitRating = 8,	AttackCrit = 14,
	SpellCrit = 14,	defense = 1.5, Dodge = 12,	Parry = 15,	Block = 5, Resilience = 25,
	RangedAttackCrit = 14,

	BaseDodge = {WARRIOR = 3.4636, PALADIN = 3.2685, HUNTER = -5.4500,	ROGUE =  -0.5900, PRIEST = 3.1830,	DEATHKNIGHT = 0.7580, SHAMAN = 1.6750,
						  MAGE = 3.4575, 	WARLOCK = 2.0350, DRUID = 4.951,},	
	-- TODO: ʽ޸
	DodgePerAgi = { WARRIOR = 30, PALADIN = 25, HUNTER = 25, ROGUE = 20, PRIEST = 25, DEATHKNIGHT = 25, SHAMAN = 25, MAGE = 25, WARLOCK = 25, DRUID = 14.7059 	},	
	CritPerAgi = {
		[1] = {0.2587, 0.2164, 0.2840, 0.4476, 0.0912, 0.2587, 0.1039, 0.0773, 0.1189, 0.1262, },
		[2] = {0.2264, 0.2164, 0.2834, 0.4290, 0.0912, 0.2264, 0.1039, 0.0773, 0.1189, 0.1262, },
		[3] = {0.2264, 0.2164, 0.2711, 0.4118, 0.0912, 0.2264, 0.0990, 0.0773, 0.1132, 0.1202, },
		[4] = {0.2264, 0.1924, 0.2530, 0.3813, 0.0868, 0.2264, 0.0990, 0.0736, 0.1132, 0.1202, },
		[5] = {0.2264, 0.1924, 0.2430, 0.3677, 0.0868, 0.2264, 0.0945, 0.0736, 0.1132, 0.1148, },
		[6] = {0.2012, 0.1924, 0.2337, 0.3550, 0.0868, 0.2012, 0.0945, 0.0736, 0.1081, 0.1148, },
		[7] = {0.2012, 0.1924, 0.2251, 0.3321, 0.0868, 0.2012, 0.0945, 0.0736, 0.1081, 0.1098, },
		[8] = {0.2012, 0.1732, 0.2171, 0.3217, 0.0829, 0.2012, 0.0903, 0.0736, 0.1081, 0.1098, },
		[9] = {0.2012, 0.1732, 0.2051, 0.3120, 0.0829, 0.2012, 0.0903, 0.0736, 0.1034, 0.1052, },
		[10] = {0.2012, 0.1732, 0.1984, 0.2941, 0.0829, 0.2012, 0.0866, 0.0703, 0.1034, 0.0971, },
		[11] = {0.1811, 0.1732, 0.1848, 0.2640, 0.0829, 0.1811, 0.0866, 0.0703, 0.0991, 0.0935, },
		[12] = {0.1811, 0.1732, 0.1670, 0.2394, 0.0793, 0.1811, 0.0831, 0.0703, 0.0991, 0.0935, },
		[13] = {0.1646, 0.1574, 0.1547, 0.2145, 0.0793, 0.1646, 0.0831, 0.0703, 0.0991, 0.0902, },
		[14] = {0.1646, 0.1574, 0.1441, 0.1980, 0.0793, 0.1646, 0.0799, 0.0703, 0.0959, 0.0902, },
		[15] = {0.1509, 0.1443, 0.1330, 0.1775, 0.0793, 0.1509, 0.0770, 0.0672, 0.0944, 0.0842, },
		[16] = {0.1509, 0.1443, 0.1267, 0.1660, 0.0760, 0.1509, 0.0742, 0.0672, 0.0928, 0.0842, },
		[17] = {0.1509, 0.1443, 0.1194, 0.1560, 0.0760, 0.1509, 0.0742, 0.0672, 0.0914, 0.0814, },
		[18] = {0.1393, 0.1332, 0.1117, 0.1450, 0.0760, 0.1393, 0.0717, 0.0672, 0.0899, 0.0789, },
		[19] = {0.1393, 0.1332, 0.1060, 0.1355, 0.0729, 0.1393, 0.0717, 0.0672, 0.0885, 0.0789, },
		[20] = {0.1293, 0.1237, 0.0998, 0.1271, 0.0729, 0.1293, 0.0670, 0.0644, 0.0871, 0.0701, },
		[21] = {0.1293, 0.1237, 0.0962, 0.1197, 0.0729, 0.1293, 0.0670, 0.0644, 0.0857, 0.0701, },
		[22] = {0.1293, 0.1237, 0.0910, 0.1144, 0.0729, 0.1293, 0.0649, 0.0644, 0.0844, 0.0682, },
		[23] = {0.1207, 0.1154, 0.0872, 0.1084, 0.0701, 0.1207, 0.0649, 0.0644, 0.0831, 0.0664, },
		[24] = {0.1132, 0.1082, 0.0829, 0.1040, 0.0701, 0.1132, 0.0630, 0.0618, 0.0818, 0.0664, },
		[25] = {0.1132, 0.1082, 0.0797, 0.0980, 0.0701, 0.1132, 0.0611, 0.0618, 0.0805, 0.0631, },
		[26] = {0.1065, 0.1082, 0.0767, 0.0936, 0.0675, 0.1065, 0.0594, 0.0618, 0.0792, 0.0631, },
		[27] = {0.1065, 0.1019, 0.0734, 0.0903, 0.0675, 0.1065, 0.0594, 0.0618, 0.0780, 0.0616, },
		[28] = {0.1006, 0.1019, 0.0709, 0.0865, 0.0675, 0.1006, 0.0577, 0.0618, 0.0768, 0.0601, },
		[29] = {0.1006, 0.0962, 0.0680, 0.0830, 0.0651, 0.1006, 0.0577, 0.0595, 0.0756, 0.0601, },
		[30] = {0.0953, 0.0962, 0.0654, 0.0792, 0.0651, 0.0953, 0.0547, 0.0595, 0.0745, 0.0549, },
		[31] = {0.0953, 0.0911, 0.0637, 0.0768, 0.0651, 0.0953, 0.0547, 0.0595, 0.0733, 0.0537, },
		[32] = {0.0905, 0.0911, 0.0614, 0.0741, 0.0629, 0.0905, 0.0533, 0.0595, 0.0722, 0.0537, },
		[33] = {0.0905, 0.0866, 0.0592, 0.0715, 0.0629, 0.0905, 0.0520, 0.0573, 0.0711, 0.0526, },
		[34] = {0.0862, 0.0866, 0.0575, 0.0691, 0.0629, 0.0862, 0.0520, 0.0573, 0.0700, 0.0515, },
		[35] = {0.0862, 0.0825, 0.0556, 0.0664, 0.0608, 0.0862, 0.0495, 0.0573, 0.0690, 0.0505, },
		[36] = {0.0823, 0.0825, 0.0541, 0.0643, 0.0608, 0.0823, 0.0483, 0.0552, 0.0679, 0.0495, },
		[37] = {0.0823, 0.0825, 0.0524, 0.0628, 0.0608, 0.0823, 0.0483, 0.0552, 0.0669, 0.0485, },
		[38] = {0.0787, 0.0787, 0.0508, 0.0609, 0.0588, 0.0787, 0.0472, 0.0552, 0.0659, 0.0485, },
		[39] = {0.0787, 0.0787, 0.0493, 0.0592, 0.0588, 0.0787, 0.0472, 0.0552, 0.0649, 0.0476, },
		[40] = {0.0755, 0.0753, 0.0481, 0.0572, 0.0588, 0.0755, 0.0452, 0.0533, 0.0639, 0.0443, },
		[41] = {0.0724, 0.0753, 0.0470, 0.0556, 0.0570, 0.0724, 0.0442, 0.0533, 0.0630, 0.0435, },
		[42] = {0.0724, 0.0753, 0.0457, 0.0542, 0.0570, 0.0724, 0.0442, 0.0533, 0.0620, 0.0435, },
		[43] = {0.0696, 0.0721, 0.0444, 0.0528, 0.0553, 0.0696, 0.0433, 0.0533, 0.0611, 0.0428, },
		[44] = {0.0696, 0.0693, 0.0433, 0.0512, 0.0553, 0.0696, 0.0424, 0.0515, 0.0602, 0.0421, },
		[45] = {0.0671, 0.0693, 0.0421, 0.0497, 0.0553, 0.0671, 0.0416, 0.0515, 0.0593, 0.0407, },
		[46] = {0.0671, 0.0666, 0.0413, 0.0486, 0.0536, 0.0671, 0.0407, 0.0515, 0.0584, 0.0401, },
		[47] = {0.0647, 0.0666, 0.0402, 0.0474, 0.0536, 0.0647, 0.0400, 0.0499, 0.0576, 0.0401, },
		[48] = {0.0624, 0.0641, 0.0391, 0.0464, 0.0521, 0.0624, 0.0392, 0.0499, 0.0567, 0.0394, },
		[49] = {0.0624, 0.0641, 0.0382, 0.0454, 0.0521, 0.0624, 0.0392, 0.0499, 0.0559, 0.0388, },
		[50] = {0.0604, 0.0618, 0.0373, 0.0440, 0.0521, 0.0604, 0.0378, 0.0483, 0.0551, 0.0366, },
		[51] = {0.0604, 0.0597, 0.0366, 0.0431, 0.0507, 0.0604, 0.0371, 0.0483, 0.0543, 0.0361, },
		[52] = {0.0584, 0.0597, 0.0358, 0.0422, 0.0507, 0.0584, 0.0365, 0.0483, 0.0535, 0.0356, },
		[53] = {0.0566, 0.0577, 0.0350, 0.0412, 0.0493, 0.0566, 0.0365, 0.0468, 0.0527, 0.0351, },
		[54] = {0.0566, 0.0577, 0.0341, 0.0404, 0.0493, 0.0566, 0.0358, 0.0468, 0.0519, 0.0351, },
		[55] = {0.0549, 0.0559, 0.0334, 0.0394, 0.0480, 0.0549, 0.0346, 0.0468, 0.0512, 0.0341, },
		[56] = {0.0549, 0.0559, 0.0328, 0.0386, 0.0480, 0.0549, 0.0341, 0.0455, 0.0504, 0.0337, },
		[57] = {0.0533, 0.0541, 0.0321, 0.0378, 0.0468, 0.0533, 0.0335, 0.0455, 0.0497, 0.0332, },
		[58] = {0.0517, 0.0525, 0.0314, 0.0370, 0.0468, 0.0517, 0.0335, 0.0455, 0.0490, 0.0328, },
		[59] = {0.0517, 0.0525, 0.0307, 0.0364, 0.0456, 0.0517, 0.0330, 0.0442, 0.0483, 0.0324, },
		[60] = {0.0503, 0.0509, 0.0301, 0.0355, 0.0456, 0.0503, 0.0320, 0.0442, 0.0476, 0.0308, },
		[61] = {0.0477, 0.0495, 0.0297, 0.0334, 0.0445, 0.0477, 0.0310, 0.0442, 0.0469, 0.0299, },
		[62] = {0.0453, 0.0481, 0.0290, 0.0322, 0.0446, 0.0453, 0.0304, 0.0442, 0.0462, 0.0295, },
		[63] = {0.0431, 0.0468, 0.0284, 0.0307, 0.0443, 0.0431, 0.0294, 0.0429, 0.0455, 0.0285, },
		[64] = {0.0421, 0.0456, 0.0279, 0.0296, 0.0434, 0.0421, 0.0285, 0.0429, 0.0449, 0.0279, },
		[65] = {0.0402, 0.0444, 0.0273, 0.0286, 0.0427, 0.0402, 0.0281, 0.0429, 0.0442, 0.0274, },
		[66] = {0.0385, 0.0444, 0.0270, 0.0276, 0.0421, 0.0385, 0.0273, 0.0418, 0.0436, 0.0269, },
		[67] = {0.0370, 0.0422, 0.0264, 0.0268, 0.0415, 0.0370, 0.0267, 0.0418, 0.0430, 0.0265, },
		[68] = {0.0355, 0.0422, 0.0259, 0.0262, 0.0413, 0.0355, 0.0261, 0.0418, 0.0424, 0.0258, },
		[69] = {0.0342, 0.0412, 0.0254, 0.0256, 0.0412, 0.0342, 0.0255, 0.0407, 0.0418, 0.0254, },
		[70] = {0.0335, 0.0403, 0.0250, 0.0250, 0.0401, 0.0335, 0.0250, 0.0407, 0.0412, 0.0250, },
		[71] = {0.0312, 0.0368, 0.0232, 0.0232, 0.0372, 0.0312, 0.0232, 0.0377, 0.0384, 0.0232, },
		[72] = {0.0287, 0.0346, 0.0216, 0.0216, 0.0344, 0.0287, 0.0216, 0.0351, 0.0355, 0.0216, },
		[73] = {0.0266, 0.0321, 0.0201, 0.0201, 0.0320, 0.0266, 0.0201, 0.0329, 0.0330, 0.0201, },
		[74] = {0.0248, 0.0299, 0.0187, 0.0187, 0.0299, 0.0248, 0.0187, 0.0303, 0.0309, 0.0187, },
		[75] = {0.0232, 0.0275, 0.0173, 0.0173, 0.0276, 0.0232, 0.0173, 0.0281, 0.0287, 0.0173, },
		[76] = {0.0216, 0.0258, 0.0161, 0.0161, 0.0257, 0.0216, 0.0161, 0.0262, 0.0264, 0.0161, },
		[77] = {0.0199, 0.0240, 0.0150, 0.0150, 0.0240, 0.0199, 0.0150, 0.0242, 0.0245, 0.0150, },
		[78] = {0.0185, 0.0222, 0.0139, 0.0139, 0.0222, 0.0185, 0.0139, 0.0227, 0.0229, 0.0139, },
		[79] = {0.0172, 0.0206, 0.0129, 0.0129, 0.0207, 0.0172, 0.0129, 0.0209, 0.0212, 0.0129, },
		[80] = {0.0160, 0.0192, 0.0120, 0.0120, 0.0192, 0.0160, 0.0120, 0.0196, 0.0198, 0.0120, },
		[81] = {0.0148, 0.0180, 0.0131, 0.0112, 0.0385, 0.0148, 0.0371, 0.0184, 0.0366, 0.0376, },
		[82] = {0.0138, 0.0168, 0.0129, 0.0105, 0.0385, 0.0138, 0.0363, 0.0174, 0.0366, 0.0369, },
		[83] = {0.0128, 0.0159, 0.0127, 0.0099, 0.0377, 0.0128, 0.0359, 0.0164, 0.0361, 0.0366, },
		[84] = {0.0120, 0.0151, 0.0124, 0.0094, 0.0370, 0.0120, 0.0355, 0.0156, 0.0357, 0.0363, },
		[85] = {0.0111, 0.0142, 0.0123, 0.0089, 0.0370, 0.0111, 0.0347, 0.0149, 0.0349, 0.0353, },
		[86] = {0.0103, 0.0135, 0.0121, 0.0085, 0.0364, 0.0103, 0.0344, 0.0142, 0.0345, 0.0350, },
		[87] = {0.0096, 0.0128, 0.0119, 0.0081, 0.0357, 0.0096, 0.0340, 0.0136, 0.0341, 0.0347, },
		[88] = {0.0089, 0.0123, 0.0117, 0.0077, 0.0357, 0.0089, 0.0333, 0.0130, 0.0333, 0.0342, },
		[89] = {0.0083, 0.0118, 0.0115, 0.0074, 0.0351, 0.0083, 0.0330, 0.0125, 0.0330, 0.0339, },
		[90] = {0.0077, 0.0112, 0.0114, 0.0071, 0.0345, 0.0077, 0.0324, 0.0120, 0.0323, 0.0333, },
		[91] = {0.0072, 0.0108, 0.0112, 0.0068, 0.0345, 0.0072, 0.0320, 0.0115, 0.0319, 0.0328, },
		[92] = {0.0067, 0.0104, 0.0111, 0.0065, 0.0339, 0.0067, 0.0314, 0.0111, 0.0316, 0.0325, },
		[93] = {0.0062, 0.0100, 0.0109, 0.0063, 0.0333, 0.0062, 0.0311, 0.0107, 0.0313, 0.0320, },
		[94] = {0.0057, 0.0097, 0.0108, 0.0061, 0.0328, 0.0057, 0.0308, 0.0104, 0.0309, 0.0318, },
		[95] = {0.0053, 0.0093, 0.0106, 0.0059, 0.0328, 0.0053, 0.0300, 0.0100, 0.0303, 0.0311, },
		[96] = {0.0050, 0.0090, 0.0105, 0.0057, 0.0323, 0.0050, 0.0297, 0.0097, 0.0300, 0.0308, },
		[97] = {0.0046, 0.0087, 0.0103, 0.0055, 0.0317, 0.0046, 0.0295, 0.0094, 0.0297, 0.0304, },
		[98] = {0.0043, 0.0084, 0.0102, 0.0053, 0.0313, 0.0043, 0.0289, 0.0091, 0.0291, 0.0299, },
		[99] = {0.0040, 0.0082, 0.0100, 0.0052, 0.0308, 0.0040, 0.0287, 0.0089, 0.0288, 0.0297, },
		[100] = {0.0037, 0.0080, 0.0099, 0.0050, 0.0308, 0.0037, 0.0282, 0.0086, 0.0283, 0.0291, },
	},
	-- TODO: DKĻݴռ
	SpellCritBase = {WARRIOR = 0, PALADIN = 3.336, HUNTER = 3.6, ROGUE = 0, PRIEST = 1.24,
		DEATHKNIGHT = 0, SHAMAN = 2.2, MAGE = 0.91, WARLOCK = 1.701, DRUID = 1.85},
	SpellCritPerInt = {
		[1] = {0.0000, 0.0832, 0.0699, 0.0000, 0.1710, 0.0000, 0.1333, 0.1637, 0.1500, 0.1431, },
		[2] = {0.0000, 0.0793, 0.0666, 0.0000, 0.1636, 0.0000, 0.1272, 0.1574, 0.1435, 0.1369, },
		[3] = {0.0000, 0.0793, 0.0666, 0.0000, 0.1568, 0.0000, 0.1217, 0.1516, 0.1375, 0.1312, },
		[4] = {0.0000, 0.0757, 0.0635, 0.0000, 0.1505, 0.0000, 0.1217, 0.1411, 0.1320, 0.1259, },
		[5] = {0.0000, 0.0757, 0.0635, 0.0000, 0.1394, 0.0000, 0.1166, 0.1364, 0.1269, 0.1211, },
		[6] = {0.0000, 0.0724, 0.0608, 0.0000, 0.1344, 0.0000, 0.1120, 0.1320, 0.1222, 0.1166, },
		[7] = {0.0000, 0.0694, 0.0608, 0.0000, 0.1297, 0.0000, 0.1077, 0.1279, 0.1179, 0.1124, },
		[8] = {0.0000, 0.0694, 0.0583, 0.0000, 0.1254, 0.0000, 0.1037, 0.1240, 0.1138, 0.1124, },
		[9] = {0.0000, 0.0666, 0.0583, 0.0000, 0.1214, 0.0000, 0.1000, 0.1169, 0.1100, 0.1086, },
		[10] = {0.0000, 0.0666, 0.0559, 0.0000, 0.1140, 0.0000, 0.1000, 0.1137, 0.1065, 0.0984, },
		[11] = {0.0000, 0.0640, 0.0559, 0.0000, 0.1045, 0.0000, 0.0933, 0.1049, 0.0971, 0.0926, },
		[12] = {0.0000, 0.0616, 0.0538, 0.0000, 0.0941, 0.0000, 0.0875, 0.0930, 0.0892, 0.0851, },
		[13] = {0.0000, 0.0594, 0.0499, 0.0000, 0.0875, 0.0000, 0.0800, 0.0871, 0.0825, 0.0807, },
		[14] = {0.0000, 0.0574, 0.0499, 0.0000, 0.0784, 0.0000, 0.0756, 0.0731, 0.0767, 0.0750, },
		[15] = {0.0000, 0.0537, 0.0466, 0.0000, 0.0724, 0.0000, 0.0700, 0.0671, 0.0717, 0.0684, },
		[16] = {0.0000, 0.0537, 0.0466, 0.0000, 0.0684, 0.0000, 0.0666, 0.0639, 0.0688, 0.0656, },
		[17] = {0.0000, 0.0520, 0.0451, 0.0000, 0.0627, 0.0000, 0.0636, 0.0602, 0.0635, 0.0617, },
		[18] = {0.0000, 0.0490, 0.0424, 0.0000, 0.0597, 0.0000, 0.0596, 0.0568, 0.0600, 0.0594, },
		[19] = {0.0000, 0.0490, 0.0424, 0.0000, 0.0562, 0.0000, 0.0571, 0.0538, 0.0569, 0.0562, },
		[20] = {0.0000, 0.0462, 0.0399, 0.0000, 0.0523, 0.0000, 0.0538, 0.0505, 0.0541, 0.0516, },
		[21] = {0.0000, 0.0450, 0.0388, 0.0000, 0.0502, 0.0000, 0.0518, 0.0487, 0.0516, 0.0500, },
		[22] = {0.0000, 0.0438, 0.0388, 0.0000, 0.0470, 0.0000, 0.0500, 0.0460, 0.0493, 0.0477, },
		[23] = {0.0000, 0.0427, 0.0368, 0.0000, 0.0453, 0.0000, 0.0474, 0.0445, 0.0471, 0.0463, },
		[24] = {0.0000, 0.0416, 0.0358, 0.0000, 0.0428, 0.0000, 0.0459, 0.0422, 0.0446, 0.0437, },
		[25] = {0.0000, 0.0396, 0.0350, 0.0000, 0.0409, 0.0000, 0.0437, 0.0405, 0.0429, 0.0420, },
		[26] = {0.0000, 0.0387, 0.0341, 0.0000, 0.0392, 0.0000, 0.0424, 0.0390, 0.0418, 0.0409, },
		[27] = {0.0000, 0.0387, 0.0333, 0.0000, 0.0376, 0.0000, 0.0412, 0.0372, 0.0398, 0.0394, },
		[28] = {0.0000, 0.0370, 0.0325, 0.0000, 0.0362, 0.0000, 0.0394, 0.0338, 0.0384, 0.0384, },
		[29] = {0.0000, 0.0362, 0.0318, 0.0000, 0.0348, 0.0000, 0.0383, 0.0325, 0.0367, 0.0366, },
		[30] = {0.0000, 0.0347, 0.0304, 0.0000, 0.0333, 0.0000, 0.0368, 0.0312, 0.0355, 0.0346, },
		[31] = {0.0000, 0.0340, 0.0297, 0.0000, 0.0322, 0.0000, 0.0354, 0.0305, 0.0347, 0.0339, },
		[32] = {0.0000, 0.0333, 0.0297, 0.0000, 0.0311, 0.0000, 0.0346, 0.0294, 0.0333, 0.0325, },
		[33] = {0.0000, 0.0326, 0.0285, 0.0000, 0.0301, 0.0000, 0.0333, 0.0286, 0.0324, 0.0318, },
		[34] = {0.0000, 0.0320, 0.0280, 0.0000, 0.0289, 0.0000, 0.0325, 0.0278, 0.0311, 0.0309, },
		[35] = {0.0000, 0.0308, 0.0269, 0.0000, 0.0281, 0.0000, 0.0314, 0.0269, 0.0303, 0.0297, },
		[36] = {0.0000, 0.0303, 0.0264, 0.0000, 0.0273, 0.0000, 0.0304, 0.0262, 0.0295, 0.0292, },
		[37] = {0.0000, 0.0297, 0.0264, 0.0000, 0.0263, 0.0000, 0.0298, 0.0254, 0.0284, 0.0284, },
		[38] = {0.0000, 0.0287, 0.0254, 0.0000, 0.0256, 0.0000, 0.0289, 0.0248, 0.0277, 0.0276, },
		[39] = {0.0000, 0.0282, 0.0250, 0.0000, 0.0249, 0.0000, 0.0283, 0.0241, 0.0268, 0.0269, },
		[40] = {0.0000, 0.0273, 0.0241, 0.0000, 0.0241, 0.0000, 0.0272, 0.0235, 0.0262, 0.0256, },
		[41] = {0.0000, 0.0268, 0.0237, 0.0000, 0.0235, 0.0000, 0.0267, 0.0230, 0.0256, 0.0252, },
		[42] = {0.0000, 0.0264, 0.0237, 0.0000, 0.0228, 0.0000, 0.0262, 0.0215, 0.0248, 0.0244, },
		[43] = {0.0000, 0.0256, 0.0229, 0.0000, 0.0223, 0.0000, 0.0254, 0.0211, 0.0243, 0.0240, },
		[44] = {0.0000, 0.0256, 0.0225, 0.0000, 0.0216, 0.0000, 0.0248, 0.0206, 0.0236, 0.0233, },
		[45] = {0.0000, 0.0248, 0.0218, 0.0000, 0.0210, 0.0000, 0.0241, 0.0201, 0.0229, 0.0228, },
		[46] = {0.0000, 0.0245, 0.0215, 0.0000, 0.0206, 0.0000, 0.0235, 0.0197, 0.0224, 0.0223, },
		[47] = {0.0000, 0.0238, 0.0212, 0.0000, 0.0200, 0.0000, 0.0231, 0.0192, 0.0220, 0.0219, },
		[48] = {0.0000, 0.0231, 0.0206, 0.0000, 0.0196, 0.0000, 0.0226, 0.0188, 0.0214, 0.0214, },
		[49] = {0.0000, 0.0228, 0.0203, 0.0000, 0.0191, 0.0000, 0.0220, 0.0184, 0.0209, 0.0209, },
		[50] = {0.0000, 0.0222, 0.0197, 0.0000, 0.0186, 0.0000, 0.0215, 0.0179, 0.0204, 0.0202, },
		[51] = {0.0000, 0.0219, 0.0194, 0.0000, 0.0183, 0.0000, 0.0210, 0.0176, 0.0200, 0.0198, },
		[52] = {0.0000, 0.0216, 0.0192, 0.0000, 0.0178, 0.0000, 0.0207, 0.0173, 0.0195, 0.0193, },
		[53] = {0.0000, 0.0211, 0.0186, 0.0000, 0.0175, 0.0000, 0.0201, 0.0170, 0.0191, 0.0191, },
		[54] = {0.0000, 0.0208, 0.0184, 0.0000, 0.0171, 0.0000, 0.0199, 0.0166, 0.0186, 0.0186, },
		[55] = {0.0000, 0.0203, 0.0179, 0.0000, 0.0166, 0.0000, 0.0193, 0.0162, 0.0182, 0.0182, },
		[56] = {0.0000, 0.0201, 0.0177, 0.0000, 0.0164, 0.0000, 0.0190, 0.0154, 0.0179, 0.0179, },
		[57] = {0.0000, 0.0198, 0.0175, 0.0000, 0.0160, 0.0000, 0.0187, 0.0151, 0.0176, 0.0176, },
		[58] = {0.0000, 0.0191, 0.0170, 0.0000, 0.0157, 0.0000, 0.0182, 0.0149, 0.0172, 0.0173, },
		[59] = {0.0000, 0.0189, 0.0168, 0.0000, 0.0154, 0.0000, 0.0179, 0.0146, 0.0168, 0.0169, },
		[60] = {0.0000, 0.0185, 0.0164, 0.0000, 0.0151, 0.0000, 0.0175, 0.0143, 0.0165, 0.0164, },
		[61] = {0.0000, 0.0159, 0.0157, 0.0000, 0.0148, 0.0000, 0.0164, 0.0143, 0.0159, 0.0162, },
		[62] = {0.0000, 0.0154, 0.0154, 0.0000, 0.0145, 0.0000, 0.0159, 0.0143, 0.0154, 0.0157, },
		[63] = {0.0000, 0.0149, 0.0150, 0.0000, 0.0143, 0.0000, 0.0152, 0.0143, 0.0148, 0.0150, },
		[64] = {0.0000, 0.0145, 0.0144, 0.0000, 0.0139, 0.0000, 0.0147, 0.0143, 0.0143, 0.0146, },
		[65] = {0.0000, 0.0140, 0.0141, 0.0000, 0.0137, 0.0000, 0.0142, 0.0142, 0.0138, 0.0142, },
		[66] = {0.0000, 0.0136, 0.0137, 0.0000, 0.0134, 0.0000, 0.0138, 0.0138, 0.0135, 0.0137, },
		[67] = {0.0000, 0.0134, 0.0133, 0.0000, 0.0132, 0.0000, 0.0134, 0.0134, 0.0130, 0.0133, },
		[68] = {0.0000, 0.0131, 0.0130, 0.0000, 0.0130, 0.0000, 0.0131, 0.0131, 0.0127, 0.0131, },
		[69] = {0.0000, 0.0128, 0.0128, 0.0000, 0.0127, 0.0000, 0.0128, 0.0128, 0.0126, 0.0128, },
		[70] = {0.0000, 0.0125, 0.0125, 0.0000, 0.0125, 0.0000, 0.0125, 0.0125, 0.0125, 0.0125, },
		[71] = {0.0000, 0.0116, 0.0116, 0.0000, 0.0116, 0.0000, 0.0116, 0.0116, 0.0116, 0.0116, },
		[72] = {0.0000, 0.0108, 0.0108, 0.0000, 0.0108, 0.0000, 0.0108, 0.0108, 0.0108, 0.0108, },
		[73] = {0.0000, 0.0101, 0.0101, 0.0000, 0.0101, 0.0000, 0.0101, 0.0101, 0.0101, 0.0101, },
		[74] = {0.0000, 0.0093, 0.0093, 0.0000, 0.0093, 0.0000, 0.0093, 0.0093, 0.0093, 0.0093, },
		[75] = {0.0000, 0.0087, 0.0087, 0.0000, 0.0087, 0.0000, 0.0087, 0.0087, 0.0087, 0.0087, },
		[76] = {0.0000, 0.0081, 0.0081, 0.0000, 0.0081, 0.0000, 0.0081, 0.0081, 0.0081, 0.0081, },
		[77] = {0.0000, 0.0075, 0.0075, 0.0000, 0.0075, 0.0000, 0.0075, 0.0075, 0.0075, 0.0075, },
		[78] = {0.0000, 0.0070, 0.0070, 0.0000, 0.0070, 0.0000, 0.0070, 0.0070, 0.0070, 0.0070, },
		[79] = {0.0000, 0.0065, 0.0065, 0.0000, 0.0065, 0.0000, 0.0065, 0.0065, 0.0065, 0.0065, },
		[80] = {0.0000, 0.0060, 0.0060, 0.0000, 0.0060, 0.0000, 0.0060, 0.0060, 0.0060, 0.0060, },
		[81] = {0.0000, 0.0056, 0.0056, 0.0000, 0.0056, 0.0000, 0.0056, 0.0056, 0.0056, 0.0056, },
		[82] = {0.0000, 0.0053, 0.0053, 0.0000, 0.0053, 0.0000, 0.0053, 0.0053, 0.0053, 0.0053, },
		[83] = {0.0000, 0.0050, 0.0050, 0.0000, 0.0050, 0.0000, 0.0050, 0.0050, 0.0050, 0.0050, },
		[84] = {0.0000, 0.0047, 0.0047, 0.0000, 0.0047, 0.0000, 0.0047, 0.0047, 0.0047, 0.0047, },
		[85] = {0.0000, 0.0044, 0.0044, 0.0000, 0.0044, 0.0000, 0.0044, 0.0044, 0.0044, 0.0044, },
		[86] = {0.0000, 0.0042, 0.0042, 0.0000, 0.0042, 0.0000, 0.0042, 0.0042, 0.0042, 0.0042, },
		[87] = {0.0000, 0.0040, 0.0040, 0.0000, 0.0040, 0.0000, 0.0040, 0.0040, 0.0040, 0.0040, },
		[88] = {0.0000, 0.0038, 0.0038, 0.0000, 0.0038, 0.0000, 0.0038, 0.0038, 0.0038, 0.0038, },
		[89] = {0.0000, 0.0037, 0.0037, 0.0000, 0.0037, 0.0000, 0.0037, 0.0037, 0.0037, 0.0037, },
		[90] = {0.0000, 0.0035, 0.0035, 0.0000, 0.0035, 0.0000, 0.0035, 0.0035, 0.0035, 0.0035, },
		[91] = {0.0000, 0.0034, 0.0034, 0.0000, 0.0034, 0.0000, 0.0034, 0.0034, 0.0034, 0.0034, },
		[92] = {0.0000, 0.0033, 0.0033, 0.0000, 0.0033, 0.0000, 0.0033, 0.0033, 0.0033, 0.0033, },
		[93] = {0.0000, 0.0031, 0.0031, 0.0000, 0.0031, 0.0000, 0.0031, 0.0031, 0.0031, 0.0031, },
		[94] = {0.0000, 0.0030, 0.0030, 0.0000, 0.0030, 0.0000, 0.0030, 0.0030, 0.0030, 0.0030, },
		[95] = {0.0000, 0.0029, 0.0029, 0.0000, 0.0029, 0.0000, 0.0029, 0.0029, 0.0029, 0.0029, },
		[96] = {0.0000, 0.0028, 0.0028, 0.0000, 0.0028, 0.0000, 0.0028, 0.0028, 0.0028, 0.0028, },
		[97] = {0.0000, 0.0027, 0.0027, 0.0000, 0.0027, 0.0000, 0.0027, 0.0027, 0.0027, 0.0027, },
		[98] = {0.0000, 0.0027, 0.0027, 0.0000, 0.0027, 0.0000, 0.0027, 0.0027, 0.0027, 0.0027, },
		[99] = {0.0000, 0.0026, 0.0026, 0.0000, 0.0026, 0.0000, 0.0026, 0.0026, 0.0026, 0.0026, },
		[100] = {0.0000, 0.0025, 0.0025, 0.0000, 0.0025, 0.0000, 0.0025, 0.0025, 0.0025, 0.0025, },
	},
		
	WARRIOR_NIGHTELF = {Strength=142,Agility=101,Stamina=132,Intellect=33,Spirit=51,HP=5584,MP=0},	
	WARRIOR_SCOURGE = {Strength=144,Agility=94,Stamina=134,Intellect=31,Spirit=58,HP=5604,MP=0},
	WARRIOR_DRAENEI = {Strength=146,Agility=93,Stamina=132,Intellect=34,Spirit=53,HP=5584,MP=0},
	WARRIOR_TAUREN = {Strength=150,Agility=91,Stamina=135,Intellect=28,Spirit=53,HP=6192,MP=0},
	WARRIOR_GNOME = {Strength=140,Agility=99,Stamina=132,Intellect=37,Spirit=51,HP=5584,MP=0},		
	WARRIOR_DWARF = {Strength=161,Agility=92,Stamina=142,Intellect=32,Spirit=50,HP=5684,MP=0},
	WARRIOR_TROLL = {Strength=146,Agility=98,Stamina=134,Intellect=29,Spirit=54,HP=5604,MP=0},
	WARRIOR_ORC = {Strength=148,Agility=93,Stamina=135,Intellect=30,Spirit=54,HP=5614,MP=0},
	DRUID_NIGHTELF = {Strength=75,Agility=77,Stamina=84,Intellect=148,Spirit=136,HP=4274,MP=4310},
	DRUID_TAUREN = {Strength=81,Agility=65,Stamina=85,Intellect=115,Spirit=155,HP=4624,MP=3815},	
	PRIEST_DWARF = {Strength=41,Agility=41,Stamina=61,Intellect=144,Spirit=157,HP=3821,MP=4687},
	PRIEST_BLOODELF = {Strength=36,Agility=47,Stamina=56,Intellect=149,Spirit=150,HP=3771,MP=4575},
	PRIEST_SCOURGE = {Strength=38,Agility=43,Stamina=59,Intellect=143,Spirit=163,HP=3801,MP=4666},
	PRIEST_DRAENEI = {Strength=40,Agility=42,Stamina=57,Intellect=146,Spirit=153,HP=3781,MP=4530},
	PRIEST_TROLL = {Strength=40,Agility=47,Stamina=59,Intellect=141,Spirit=152,HP=3801,MP=4455},
	PRIEST_HUMAN = {Strength=39,Agility=45,Stamina=58,Intellect=145,Spirit=166,HP=3791,MP=4515},
	PRIEST_NIGHTELF = {Strength=36,Agility=50,Stamina=57,Intellect=145,Spirit=151,HP=3781,MP=4515},	
	ROGUE_HUMAN = {Strength=95,Agility=158,Stamina=89,Intellect=39,Spirit=63,HP=4414,MP=0},
	ROGUE_NIGHTELF = {Strength=92,Agility=166,Stamina=91,Intellect=39,Spirit=58,HP=4434,MP=0},	
	ROGUE_BLOODELF = {Strength=92,Agility=160,Stamina=87,Intellect=43,Spirit=57,HP=4394,MP=0},
	ROGUE_SCOURGE = {Strength=94,Agility=156,Stamina=90,Intellect=37,Spirit=63,HP=4424,MP=0},
	ROGUE_TROLL = {Strength=96,Agility=160,Stamina=90,Intellect=35,Spirit=59,HP=4424,MP=0},
	ROGUE_DWARF = {Strength=97,Agility=157,Stamina=95,Intellect=38,Spirit=57,HP=4474,MP=0},
	ROGUE_GNOME = {Strength=90,Agility=161,Stamina=88,Intellect=44,Spirit=58,HP=4404,MP=0},
	ROGUE_ORC = {Strength=98,Agility=155,Stamina=91,Intellect=36,Spirit=63,HP=4434,MP=0},	
	HUNTER_BLOODELF = {Strength=61,Agility=153,Stamina=106,Intellect=81,Spirit=82,HP=5546,MP=4318},
	HUNTER_TAUREN = {Strength=69,Agility=146,Stamina=110,Intellect=72,Spirit=85,HP=6080,MP=4183},	
	PALADIN_BLOODELF = {Strength=133,Agility=79,Stamina=118,Intellect=95,Spirit=88,HP=4377,MP=4098},
	PALADIN_DWARF = {Strength=128,Agility=73,Stamina=123,Intellect=90,Spirit=88,HP=4427,MP=4023},
	PALADIN_DRAENEI = {Strength=127,Agility=74,Stamina=119,Intellect=92,Spirit=91,HP=4387,MP=4053},
	PALADIN_HUMAN = {Strength=126,Agility=77,Stamina=120,Intellect=91,Spirit=97,HP=4397,MP=4038},	
	MAGE_BLOODELF = {Strength=30,Agility=41,Stamina=49,Intellect=155,Spirit=144,HP=3723,MP=4286},
	MAGE_SCOURGE = {Strength=32,Agility=37,Stamina=52,Intellect=171,Spirit=150,HP=3733,MP=4526},
	MAGE_GNOME = {Strength=28,Agility=42,Stamina=50,Intellect=161,Spirit=145,HP=3713,MP=4376},
	MAGE_TROLL = {Strength=34,Agility=41,Stamina=52,Intellect=147,Spirit=146,HP=3753,MP=4166},
	MAGE_HUMAN = {Strength=33,Agility=39,Stamina=51,Intellect=151,Spirit=159,HP=3723,MP=4226},
	MAGE_DRAENEI = {Strength=34,Agility=36,Stamina=50,Intellect=174,Spirit=147,HP=3713,MP=4571},	
	WARLOCK_HUMAN = {Strength=51,Agility=58,Stamina=87,Intellect=133,Spirit=145,HP=4475,MP=4597},
	WARLOCK_SCOURGE = {Strength=50,Agility=56,Stamina=88,Intellect=131,Spirit=136,HP=4190,MP=4300},
	WARLOCK_ORC = {Strength=54,Agility=55,Stamina=89,Intellect=130,Spirit=134,HP=4554,MP=4521},
	WARLOCK_BLOODELF = {Strength=48,Agility=60,Stamina=85,Intellect=137,Spirit=131,HP=4160,MP=4390},
	WARRIOR_HUMAN = {Strength=140,Agility=99,Stamina=132,Intellect=37,Spirit=51,HP=5584,MP=0},
	WARLOCK_GNOME = {Strength=46,Agility=61,Stamina=86,Intellect=142,Spirit=132,HP=4444,MP=4729},	
	HUNTER_TROLL = {Strength=65,Agility=153,Stamina=109,Intellect=73,Spirit=84,HP=5513,MP=4198},	
	HUNTER_DWARF = {Strength=66,Agility=147,Stamina=111,Intellect=76,Spirit=82,HP=4796,MP=4244},
	HUNTER_ORC = {Strength=67,Agility=148,Stamina=110,Intellect=74,Spirit=86,HP=5636,MP=4213},
	HUNTER_DRAENEI = {Strength=65,Agility=148,Stamina=107,Intellect=78,Spirit=85,HP=4524,MP=4273},	
	HUNTER_NIGHTELF = {Strength=61,Agility=156,Stamina=107,Intellect=77,Spirit=83,HP=4877,MP=4258},	
	SHAMAN_TAUREN = {Strength=107,Agility=59,Stamina=116,Intellect=103,Spirit=122,HP=4548,MP=4636},
	SHAMAN_TROLL = {Strength=103,Agility=66,Stamina=115,Intellect=104,Spirit=121,HP=4129,MP=4501},
	SHAMAN_ORC = {Strength=105,Agility=61,Stamina=116,Intellect=105,Spirit=123,HP=4139,MP=4253},
	SHAMAN_DRAENEI = {Strength=103,Agility=61,Stamina=113,Intellect=109,Spirit=122,HP=4109,MP=4736},

}
--------------------
-- ==Agility==
function M:GetDodgePerAgi(v,l,c,r) -- level < 70 ʱ׼ȷ
	if (l == 70) then
		return self.base.DodgePerAgi[c];
	else
		local base, modifier = UnitDefense("player");
		local dodgefrDefense = ((base + modifier) - l * 5) * 0.04;
		local dodgefrTalent = 0;
		if (c == "ROGUE") then
			dodgefrTalent = select(5, GetTalentInfo(2, 3));
		elseif (c == "DRUID") then
			dodgefrTalent = select(5, GetTalentInfo(2, 6)) * 2;
		end
		local dodgefrRace = (r == "NIGHTELF") and 1 or 0;
		local dodgefrRating = self:GetRatingInPercent("Dodge", GetCombatRating(CR_DODGE), l);
		local dodgeFromAgi = GetDodgeChance() - dodgefrRating - dodgefrDefense - dodgefrTalent - dodgefrRace - self.base.BaseDodge[c];
		return dodgeFromAgi / select(2, UnitStat("player", 2));
	end
end

function M:GetDodgeFromAgi(v,l,c,r)
	return self:GetDodgePerAgi(v,l,c,r) * (v or 0);
end

function M:GetCritPerAgi(v,l,c,r)
	return self.base.CritPerAgi[l][self.Class2Id[c]];
end

function M:GetCritFromAgi(v,l,c,r)
	return self:GetCritPerAgi(v,l,c,r) * (v or 0);
end
-- == Stamina == 
-- û츳. 
function M:GetHPfromStamina(v,l,c,r)
	return (v or 0) * 10;
end

function M:GetMPfromIntellect(v,l,c,r)
	return (v or 0) * 15;
end

function M:GetSpellCritFromInt(v,l,c,r)
	return self:GetSpellCritPerInt(v,l,c,r) * (v or 0);
end

function M:GetSpellCritPerInt(v,l,c,r)
	return self.base.SpellCritPerInt[l][self.Class2Id[c]] or 0;
end
---------------------
M.logic = {	
--[[
	MountSpeed = function(v) return v.."%" end,
	RunSpeed = function(v) return v.."%" end,
]]
	defense = function(v,t,l,c,r)	
		-- t.effect.defense2ȷֻһ.
		local v = v or t:GetEffect("defense");		
		t.effect.defense2 = t.effect.defense2 or 350 + floor(t:GetRatingInPercent("defense", v, l));
		t.effect.defense = t.effect.defense2;
		return t.effect.defense;
	end,

	HitRating = function(v,t,l,c,r)
		t.effect.HitRating = t:GetRatingInPercent("HitRating",v,l);
	end,

	SpellHitRating = function(v,t,l,c,r)
		t.effect.SpellHitRating = t:GetRatingInPercent("SpellHitRating",v,l);
	end,

	ManaRestore = function(v,t,l,c,r)
		local value = 0;
		--local value = v and math.sqrt(t:GetEffect("Intellect")/460)*t:GetEffect("Spirit") or 0;
		
		if c == "PRIEST" or c == "MAGE" then
			value = (t:GetEffect("Spirit") / 4 +12.5) * 2.5 * t:GetEffect("ManaRestore2") + (v or 0);
		elseif c == "PALADIN" or c == "WARLOCK" or c == "HUNTER" then
			value = (t:GetEffect("Spirit") / 5 +15) * 2.5 * t:GetEffect("ManaRestore2") + (v or 0);
		elseif c == "SHAMAN" then
			value = (t:GetEffect("Spirit") / 5 +17) * 2.5 * t:GetEffect("ManaRestore2") + (v or 0);
		elseif c == "DRUID" then
			value = (t:GetEffect("Spirit") / 4.5 +15) * 2.5 * t:GetEffect("ManaRestore2") + (v or 0);
		end

		t.effect.ManaRestore = floor(value);
	end,

	HasteSpell = function(v,t,l,c,r)
		t.effect.HasteSpell = t:GetRatingInPercent("HasteSpell",v,l);
	end,

	HasteRanged = function(v,t,l,c,r)
		t.effect.HasteRanged = t:GetRatingInPercent("HasteRanged",v,l);
	end,

	HasteMelee = function(v,t,l,c,r)
		t.effect.HasteMelee = t:GetRatingInPercent("HasteMelee",v,l);
	end,

	ArmorReduce = function(v,t,l,c,r)
		if l > 59 then
			l = l + (4.5 * (l - 59));
		end		
		-- ׼, ȷ˳޴
		t.effect.Armor = t:GetEffect("Armor") + t:GetEffect("Agility") * 2;
	
		local armorreduce = 0.1 * t.effect.Armor / ( 8.5 * l + 40);
		armorreduce = 100 * armorreduce / (1 + armorreduce) + t:GetEffect("ArmorReduce2");		
		t.effect.ArmorReduce = min(armorreduce, 75);
	end,

	SpellCrit = function(v,t,l,c,r)
		t.effect.SpellCrit = t:GetEffect("Intellect") * (t:GetSpellCritPerInt(v, l, c, r) or 0) + t:GetRatingInPercent("SpellCrit", v, l) + (t.base.SpellCritBase[c] or 0);
	end,

	AttackCrit = function(v,t,l,c,r)
		local value = t:GetEffect("Agility") * (t:GetCritPerAgi(v, l, c, r) or 0) + t:GetRatingInPercent("AttackCrit", v, l);
		if c == "DRUID" then
			value = value + 0.9;
		elseif c == "PALADIN" then
			value = value + 0.7;
		elseif c == "WARLOCK" then
			value = value + 2;
		elseif c == "PRIEST" then 
			value = value + 3.18;
		elseif c == "MAGE" then
			value = value + 3.46;
		elseif c == "SHAMAN" then
			value = value + 1.7;
		end
		t.effect.AttackCrit = value;
		return value;
	end,

	RangedAttackCrit = function(v,t,l,c,r)	-- ùʽ׼ȷ(Ҳµ~~)
		local value = t:GetEffect("Agility") * (t:GetCritPerAgi(v, l, c, r) or 0) + t:GetRatingInPercent("RangedAttackCrit", v, l);
		if c == "DRUID" then
			value = value + 0.9;
		elseif c == "PALADIN" then
			value = value + 0.7;
		elseif c == "WARLOCK" then
			value = value + 2;
		elseif c == "PRIEST" then 
			value = value + 3.18;
		elseif c == "MAGE" then
			value = value + 3.46;
		elseif c == "SHAMAN" then
			value = value + 1.7;
		end	
		t.effect.RangedAttackCrit = value;
	end,

	Block = function(v,t,l,c,r)
		if (c == "WARRIOR" or c == "SHAMAN" or c == "PALADIN") then			
			t.effect.Block = t:GetRatingInPercent("Block", v, l) + ((M.logic.defense(nil, t,l,c,r) - l * 5) or 0)* 0.04 + 5;
		else
			t.effect.Block = 0;
		end
	end,

	Parry = function(v,t,l,c,r)
		if (c == "WARRIOR" or c == "ROGUE" or c == "SHAMAN" or c == "HUNTER" or c == "PALADIN") then
			t.effect.Parry = t:GetRatingInPercent("Parry", v, l) + ((M.logic.defense(nil, t,l,c,r) - l * 5) or 0)* 0.04 + 5;
		else
			t.effect.Parry = 0;
		end		
	end,

	AttackPower = function(v, t, l, c, r)
		local value = 0;
		if c == "DRUID" then
			value = 2 * t:GetEffect("Strength") - 20;
		elseif c == "MAGE" or c == "PRIEST" or c == "WARLOCK" then
			value = t:GetEffect("Strength") - 10;
		elseif c == "HUNTER" or c == "ROGUE" then
			value = l * 2 + t:GetEffect("Strength") + t:GetEffect("Agility") - 20;
		elseif c == "WARRIOR" or c == "PALADIN" then
			value = l * 3 + t:GetEffect("Strength") * 2 - 20;
		elseif c == "SHAMAN" then
			value = l * 2 + t:GetEffect("Strength") * 2 - 20;
		end
		t.effect.AttackPower = value + t:GetEffect("AttackPower");
	end,

	RangedAttackPower = function(v,t,l,c,r)
		if c == "HUNTER" then
			t.effect.RangedAttackPower = l * 2 + t:GetEffect("Strength") + t:GetEffect("Agility") - 20 + t:GetEffect("RangedAttackPower");
		end
	end,

	Dodge = function(v,t,l,c,r)
		t.effect.Dodge = t:GetRatingInPercent("Dodge", v, l) + (t.base.BaseDodge[c] or 0) + t:GetEffect("Agility") / (t.base.DodgePerAgi[c] or 1000000) + (r == "NIGHTELF" and 1 or 0) + (((t.effect.defense or 350) - UnitLevel("player") * 5) or 0) * 0.04;
 	end,

	HP = function(v,t,l,c,r)
		t.effect.HP = t:GetEffect("hp") + t:GetBaseEffect("HP", c, r, l) + t:GetEffect("Stamina") * 10 - t:GetBaseEffect("Stamina", c, r, l) * 10;
	end,

	--Armor = function(v,t,l,c,r)		
	--	t.effect.Armor = t:GetEffect("Armor") + t:GetEffect("Agility") * 2;		
	--end,
};
