local T = LibStub("AceAddon-3.0"):GetAddon("GDKP") if not T then return end T.Templates = T.Templates or {} local AceOO = AceLibrary("AceOO-2.0") if not AceOO then return end local dateFormat = "%H:%M" local IGoldBehavior = AceOO.Interface{ SetIncome = "function", GetIncome = "function", SetExpense = "function", GetExpense = "function"} local IUnitBehavior = AceOO.Interface{ SetUnit = "function", GetUnit = "function"} local IItemBehavior = AceOO.Interface{ SetItem = "function", GetItem = "function"} local NoGoldBehavior = AceOO.Class(IGoldBehavior) function NoGoldBehavior.prototype:SetIncome() error("<NoGoldBehavior>: SetIncome() is forbidden in NoGoldBehavior") end function NoGoldBehavior.prototype:GetIncome() end function NoGoldBehavior.prototype:SetExpense() error("<NoGoldBehavior>: SetIncome() is forbidden in NoGoldBehavior") end function NoGoldBehavior.prototype:GetExpense() end local IncomeGoldBehavior = AceOO.Class(IGoldBehavior) function IncomeGoldBehavior.prototype:SetIncome(income) self.income = income end function IncomeGoldBehavior.prototype:GetIncome() return self.income end function IncomeGoldBehavior.prototype:SetExpense() error("<IncomeGoldBehavior>: SetExpense() is forbidden in IncomeGoldBehavior") end function IncomeGoldBehavior.prototype:GetExpense() end local ExpenseGoldBehavior = AceOO.Class(IGoldBehavior) function ExpenseGoldBehavior.prototype:SetIncome() error("<ExpenseGoldBehavior>: SetIncome() is forbidden in ExpenseGoldBehavior") end function ExpenseGoldBehavior.prototype:GetIncome() end function ExpenseGoldBehavior.prototype:SetExpense(expense) self.expense = expense end function ExpenseGoldBehavior.prototype:GetExpense() return self.expense end local BothGoldBehavior = AceOO.Class(IGoldBehavior) function BothGoldBehavior.prototype:SetIncome(income) self.income = income end function BothGoldBehavior.prototype:GetIncome() return self.income end function BothGoldBehavior.prototype:SetExpense(expense) self.expense = expense end function BothGoldBehavior.prototype:GetExpense() return self.expense end local NoUnitBehavior = AceOO.Class(IUnitBehavior) function NoUnitBehavior.prototype:SetUnit() error("<NoUnitBehavior>: SetUnit() is forbidden in NoUnitBehavior") end function NoUnitBehavior.prototype:GetUnit() end local NormalUnitBehavior = AceOO.Class(IUnitBehavior) function NormalUnitBehavior.prototype:SetUnit(unit) self.unit = unit end function NormalUnitBehavior.prototype:GetUnit() return self.unit end local NoItemBehavior = AceOO.Class(IItemBehavior) function NoItemBehavior.prototype:SetItem() error("<NoItemBehavior>: SetItem() is forbidden in NoItemBehavior") end function NoItemBehavior.prototype:GetItem() end local NormalItemBehavior = AceOO.Class(IItemBehavior) function NormalItemBehavior.prototype:SetItem(item) self.item = item end function NormalItemBehavior.prototype:GetItem() return self.item end local Savable = AceOO.Class() Savable.virtual = true function Savable.prototype:init(saveTable) Savable.super.prototype.init(self) self.save = saveTable end function Savable.prototype:GetSaveTable() return self.save end function Savable.prototype:Save() assert(self.save,"<Savable>: save table does not exist!") self:SaveAttributes() end function Savable.prototype:Load() assert(self.save,"<Savable>: save table does not exist!") self:LoadAttributes() end function Savable.prototype:SaveAttribute(name,val) self.save[name] = val end function Savable.prototype:LoadAttribute(name) return self.save[name] end function Savable.prototype:SaveAttributes() error("<Savable>: Subclass need to implement SaveAttributes() method") end function Savable.prototype:LoadAttributes() error("<Savable>: Must implement LoadAttributes() method") end local Account = AceOO.Class(Savable) function Account.prototype:init(saveTable) Account.super.prototype.init(self,saveTable) self:Load() end function Account.prototype:SetIncomeList(list) self.incomeList = list end function Account.prototype:SetUserSetted(flag) self.userSet = flag self:Save() end function Account.prototype:IsUserSetted() return self.userSet end function Account.prototype:SetExpenseList(list) self.expenseList = list end function Account.prototype:SetNumMembers(num) self.numMember = num self:Save() end function Account.prototype:GetNumMembers() return self.numMember end function Account.prototype:GetAverage() assert(self:GetNumMembers() >0, "<Account>: Number of member need to be larger than 0" ) return self:GetProfit()/self:GetNumMembers() end function Account.prototype:GetProfit() return self:GetIncome() - self:GetExpense() end function Account.prototype:GetIncome() local income = 0 for i = 1, #self.incomeList do income = income + (self.incomeList[i]:GetIncome() or 0) end return income end function Account.prototype:GetExpense(arg1) local expense,eType = 0 for i = 1, #self.expenseList do if not arg1 then expense = expense + (self.expenseList[i]:GetExpense() or 0) else _,eType = self.expenseList[i]:GetExpenseType() if eType == arg1 then expense = expense + self.expenseList[i]:GetExpense() end end end return expense end function Account.prototype:SaveAttributes() self:SaveAttribute("numMembers",self:GetNumMembers()) self:SaveAttribute("userSet",self:IsUserSetted()) end function Account.prototype:LoadAttributes() self.numMember = self:LoadAttribute("numMembers") self.userSet = self:LoadAttribute("userSet") end local VRecord = AceOO.Class(Savable) VRecord.virtual = true function VRecord.prototype:Equals(other) return self.uid == other.uid end function VRecord.prototype:init(savetable) VRecord.super.prototype.init(self,savetable) self.ctime = self:LoadAttribute("ctime") or time() end function VRecord.prototype:GetDesc() error("<VRecord>: must implement GetDesc()") end function VRecord.prototype:GetCTime() return self.ctime end function VRecord.prototype:SetIncome(...) assert(self.goldBehavior,"<VRecord>: Record need to have a gold behavior") self.goldBehavior:SetIncome(...) self:Save() end function VRecord.prototype:GetIncome() assert(self.goldBehavior,"<VRecord>: Record need to have a gold behavior") return self.goldBehavior:GetIncome() end function VRecord.prototype:SetExpense(...) assert(self.goldBehavior,"<VRecord>: Record need to have a gold behavior") self.goldBehavior:SetExpense(...) self:Save() end function VRecord.prototype:GetExpense() assert(self.goldBehavior,"<VRecord>: Record need to have a gold behavior") return self.goldBehavior:GetExpense() end function VRecord.prototype:SetUnit(...) assert(self.unitBehavior,"<VRecord>: Record need to have an unit behavior") self.unitBehavior:SetUnit(...) self:Save() end function VRecord.prototype:GetUnit() assert(self.unitBehavior,"<VRecord>: Record need to have an unit behavior") return self.unitBehavior:GetUnit() end function VRecord.prototype:SetItem(...) assert(self.itemBehavior,"<VRecord>: Record need to have an item behavior") self.itemBehavior:SetItem(...) self:Save() end function VRecord.prototype:GetItem() assert(self.itemBehavior,"<VRecord>: Record need to have an item behavior") return self.itemBehavior:GetItem() end function VRecord.prototype:ToString() return ("<%s>: \n CTime -> %s\n Income -> %s\n Expense -> %s\n Unit -> %s\n Item -> %s\n Description -> %s"):format( self.class:ToString(), self:GetCTime() or "N/A", self:GetIncome() or "N/A", self:GetExpense() or "N/A", self:GetUnit() or "N/A", self:GetItem() or "N/A" , self:GetDesc() or "N/A") end function VRecord.prototype:Report() error("SubClass must implement Report() method") end local NormalItemRecord = AceOO.Class(VRecord) function NormalItemRecord:ToString() return "NormalItemRecord" end function NormalItemRecord.prototype:init(sTable,item,player) NormalItemRecord.super.prototype.init(self,sTable) self.itemBehavior = NormalItemBehavior:new() self.unitBehavior = NormalUnitBehavior:new() self.goldBehavior = IncomeGoldBehavior:new() self:Load() self:Save() if item then self:SetItem(item) end if player then self:SetUnit(player) end end function NormalItemRecord.prototype:GetDesc() if self:GetItem() then if self:GetUnit() then return string.format("%s 获得 %s",self:GetUnit(),self:GetItem()) else return string.format("%s 未分配",self:GetItem()) end else return self.desc end end function NormalItemRecord.prototype:SaveAttributes() self:SaveAttribute("item",self:GetItem()) self:SaveAttribute("unit",self:GetUnit()) self:SaveAttribute("ctime",self:GetCTime()) self:SaveAttribute("income",self:GetIncome()) self:SaveAttribute("type","NormalItem") end function NormalItemRecord.prototype:LoadAttributes() self.itemBehavior:SetItem(self:LoadAttribute("item")) self.unitBehavior:SetUnit(self:LoadAttribute("unit")) self.goldBehavior:SetIncome(self:LoadAttribute("income")) end function NormalItemRecord.prototype:Report() local income = self:GetIncome() local str = ("时间：%s\n"):format(date(dateFormat,self:GetCTime())) str=str..("事件：%s\n"):format(self:GetDesc()) if income then str = str ..("收入为：%s。\n"):format(income) end return str end local SpecialIncomeRecord = AceOO.Class(VRecord) local function GDKP_e8d7727d9d83a3ae1f08c5f068ac16ba(itemString) return end function SpecialIncomeRecord:ToString() return "SpecialIncomeRecord" end function SpecialIncomeRecord.prototype:init(sTable,desc) SpecialIncomeRecord.super.prototype.init(self,sTable) self.itemBehavior = NormalItemBehavior:new() self.unitBehavior = NormalUnitBehavior:new() self.goldBehavior = IncomeGoldBehavior:new() self:Load() if desc then self:SetDesc(desc) end end function SpecialIncomeRecord.prototype:SetDesc(...) local descStr = ... local item = GDKP_e8d7727d9d83a3ae1f08c5f068ac16ba(descStr) if item then self:SetItem(item) else self.desc = descStr end self:Save() end function SpecialIncomeRecord.prototype:GetDesc() if self:GetItem() then if self:GetUnit() then return string.format("%s 获得 %s",self:GetUnit(),self:GetItem()) else return string.format("%s 未分配",self:GetItem()) end else return self.desc end end function SpecialIncomeRecord.prototype:SaveAttributes() self:SaveAttribute("item",self:GetItem()) self:SaveAttribute("desc",self:GetDesc()) self:SaveAttribute("ctime",self:GetCTime()) self:SaveAttribute("income",self:GetIncome()) self:SaveAttribute("type","SpecialIncome") end function SpecialIncomeRecord.prototype:LoadAttributes() self.itemBehavior:SetItem(self:LoadAttribute("item")) self.goldBehavior:SetIncome(self:LoadAttribute("income")) local descStr = self:LoadAttribute("desc") local item = GDKP_e8d7727d9d83a3ae1f08c5f068ac16ba(descStr) if item then self.itemBehavior:SetItem(item) else self.desc = descStr end end function SpecialIncomeRecord.prototype:Report() local income = self:GetIncome() local str = ("时间：%s\n"):format(date(dateFormat,self:GetCTime())) str=str..("事件：%s\n"):format(self:GetDesc()) if income then str = str ..("收入为：%s。\n"):format(income) end return str end local ExpenseRecord = AceOO.Class(VRecord) ExpenseRecord.types={ "GENERAL_EXPENSE", "TANK_SUBSIDY", "HEALER_SUBSIDY" } function ExpenseRecord:ToString() return "ExpenseRecord" end function ExpenseRecord.prototype:init(sTable,typeId) ExpenseRecord.super.prototype.init(self,sTable) self.itemBehavior = NormalItemBehavior:new() self.unitBehavior = NoUnitBehavior:new() self.goldBehavior = ExpenseGoldBehavior:new() self:Load() if typeId then self:SetExpenseType(typeId) end end function ExpenseRecord.prototype:SetDesc(desc) self.desc = desc self:Save() end function ExpenseRecord.prototype:GetExpenseType() for i = 1, #ExpenseRecord.types do if self.eventType == ExpenseRecord.types[i] then return i,self.eventType end end end function ExpenseRecord.prototype:SetExpenseType(id) if id then assert(id > 0 and id <= #(ExpenseRecord.types),"<TrivialRecord>: Invalid record type") self.eventType = ExpenseRecord.types[id] end self:Save() end function ExpenseRecord.prototype:GetDesc() if self.eventType =="GENERAL_EXPENSE" then return self.desc elseif self.eventType =="TANK_SUBSIDY" then return "坦克补助" elseif self.eventType =="HEALER_SUBSIDY" then return "治疗补助" end end function ExpenseRecord.prototype:SaveAttributes() self:SaveAttribute("desc",self:GetDesc()) self:SaveAttribute("ctime",self:GetCTime()) self:SaveAttribute("expense",self:GetExpense()) self:SaveAttribute("eventId",self:GetExpenseType()) self:SaveAttribute("type","Expense") end function ExpenseRecord.prototype:LoadAttributes() self.desc = self:LoadAttribute("desc") self.goldBehavior:SetExpense(self:LoadAttribute("expense")) local id =self:LoadAttribute("eventId") if id then assert(id > 0 and id <= #(ExpenseRecord.types),"<TrivialRecord>: Invalid record type") self.eventType = ExpenseRecord.types[id] end end function ExpenseRecord.prototype:ToString() return ("<%s>: \n CTime -> %s\n Income -> %s\n Expense -> %s\n Unit -> %s\n Item -> %s\n Description -> %s\n ExpenseType -> %s"):format( self.class:ToString(), self:GetCTime() or "N/A", self:GetIncome() or "N/A", self:GetExpense() or "N/A", self:GetUnit() or "N/A", self:GetItem() or "N/A" , self:GetDesc() or "N/A", select(2,self:GetExpenseType()) or "N/A") end function ExpenseRecord.prototype:Report() local expense = self:GetExpense() local str = ("时间：%s\n"):format(date(dateFormat,self:GetCTime())) str=str..("事件：%s\n"):format(self:GetDesc()) if expense then str = str ..("支出为：%s。\n"):format(expense) end return str end local TrivialRecord = AceOO.Class(VRecord) TrivialRecord.types={ "ENTER_RAID", "LEAVE_RAID", } function TrivialRecord:ToString() return "TrivialRecord" end function TrivialRecord.prototype:init(sTable,typeId,unit) TrivialRecord.super.prototype.init(self,sTable) self.itemBehavior = NoItemBehavior:new() self.unitBehavior = NormalUnitBehavior:new() self.goldBehavior = NoGoldBehavior:new() self:Load() if typeId then self:SetTrivialType(typeId) end if unit then self:SetUnit(unit) end end function TrivialRecord.prototype:GetDesc() local unit = self:GetUnit() if unit and self.eventType =="LEAVE_RAID" then return unit.." 离开团队" elseif unit and self.eventType =="ENTER_RAID" then return unit.." 加入团队" end end function TrivialRecord.prototype:GetTrivialType() for i = 1, #TrivialRecord.types do if self.eventType == TrivialRecord.types[i] then return i,self.eventType end end end function TrivialRecord.prototype:SetTrivialType(id) if id then assert(id > 0 and id <= #(TrivialRecord.types),"<TrivialRecord>: Invalid record type") self.eventType = TrivialRecord.types[id] end self:Save() end function TrivialRecord.prototype:SaveAttributes() self:SaveAttribute("unit",self:GetUnit()) self:SaveAttribute("ctime",self:GetCTime()) self:SaveAttribute("eventId",self:GetTrivialType()) self:SaveAttribute("type","Trivial") end function TrivialRecord.prototype:LoadAttributes() self.unitBehavior:SetUnit(self:LoadAttribute("unit")) local id = self:LoadAttribute("eventId") if id then assert(id > 0 and id <= #(TrivialRecord.types),"<TrivialRecord>: Invalid record type") self.eventType = TrivialRecord.types[id] end end function TrivialRecord.prototype:ToString() return ("<%s>: \n CTime -> %s\n Income -> %s\n Expense -> %s\n Unit -> %s\n Item -> %s\n Description -> %s \n TrivialType -> %s"):format( self.class:ToString(), self:GetCTime() or "N/A", self:GetIncome() or "N/A", self:GetExpense() or "N/A", self:GetUnit() or "N/A", self:GetItem() or "N/A" , self:GetDesc() or "N/A", select(2,self:GetTrivialType()) or "N/A") end function TrivialRecord.prototype:Report() local str = ("时间：%s\n"):format(date(dateFormat,self:GetCTime())) str=str..("事件：%s\n"):format(self:GetDesc()) return str end local UIObject = AceOO.Class() UIObject.virtual = true function UIObject.prototype:CreateUI() error("<UIObject>: Must implement CreateUI() method") end function UIObject.prototype:Show(...) if self.ui then self.ui:Show(...) end end function UIObject.prototype:Hide(...) if self.ui then self.ui:Hide(...) end end function UIObject.prototype:RegisterForClicks(...) self.ui:RegisterForClicks(...) end function UIObject.prototype:SetScript(...) self.ui:SetScript(...) end function UIObject.prototype:SetPoint(...) if self.ui then self.ui:SetPoint(...) end end function UIObject.prototype:SetWidth(...) if self.ui then self.ui:SetWidth(...) end end function UIObject.prototype:SetHeight(...) if self.ui then self.ui:SetHeight(...) end end function UIObject.prototype:SetAlpha(...) if self.ui then self.ui:SetAlpha(...) end end function UIObject.prototype:SetScale(...) if self.ui then self.ui:SetScale(...) end end function UIObject.prototype:ClearAllPoints(...) if self.ui then self.ui:ClearAllPoints(...) end end function UIObject.prototype:SetParent(...) self.ui:SetParent(...) end local RecordUI = AceOO.Class(UIObject) RecordUI.virtual = true function RecordUI.prototype:init(name,record) RecordUI.super.prototype.init(self) self:CreateUI(name) self.ui.object = self if self.editButton and self.editable then self.editButton:SetScript("OnClick",function(frame) self.editable:SetRecord(self:GetRecord()) self.editable:SetPoint("BOTTOMLEFT",frame,"TOPLEFT",0,0) self.editable:SetCommitCallback(self.editableCallback) self.editable:Update() self.editable:Show() end) self.editable:SetCell(self) end if record then self:SetRecord(record) end end function RecordUI.prototype:SetRecord(...) local record = ... assert(AceOO.inherits(record,VRecord),"<Cell>: Invalid record!") self.record =record end function RecordUI.prototype:GetRecord() return self.record end function RecordUI.prototype:ClearRecord() self.record = nil end function RecordUI.prototype:Update() local record = self:GetRecord() if record then self:UpdateUIElements() self:Show() else self:Hide() end end function RecordUI.prototype:UpdateUIElements() error("<Cell>: Must implement UpdateUIElements() method") end function RecordUI.prototype:SetEditableCallback(callback) self.editableCallback = callback end function RecordUI.prototype:SetDeleteCallback(callback) self.deleteCallback = callback if self.deleteButton then self.deleteButton:SetScript("OnClick",function() pcall(self.deleteCallback,self) end) end end local RecordEditable = AceOO.Class(RecordUI) RecordEditable.virtual = true function RecordEditable.prototype:init(name,record) RecordEditable.super.prototype.init(self,name,record) end function RecordEditable.prototype:Show() RecordEditable.super.prototype.Show(self) if self.proceedButton then self.proceedButton:SetScript("OnClick",function() self:OnProceed() end) end if self.cancelButton then self.cancelButton:SetScript("OnClick",function() self:OnCancel() end) end self.ui:SetClampedToScreen(true) end function RecordEditable.prototype:OnCancel() self:Hide() end function RecordEditable.prototype:GetCell() return self.cell end function RecordEditable.prototype:SetCell(cell) self.cell = cell end function RecordEditable.prototype:OnProceed() if self:GetRecord() then self:CommitRecord() end if self:GetCell() then self:GetCell():Update() end if self.commitCallback then pcall(self.commitCallback,self) end self:Hide() end function RecordEditable.prototype:Update() local record = self:GetRecord() if record then self:UpdateUIElements() end end function RecordEditable.prototype:CommitRecord() error("<RecordEditable>: Sub class need to implement CommitRecord()") end function RecordEditable.prototype:SetCommitCallback(callback) self.commitCallback = callback end local RecordGoldEditable = AceOO.Class(RecordEditable) function RecordGoldEditable.prototype:CreateUI(name) self.ui = _G[name] or CreateFrame("Button",name,UIParent,"GDKPGoldEditableTemplate") self.goldText = _G[self.ui:GetName().."GoldText"] self.proceedButton = _G[self.ui:GetName().."ProceedButton"] self.cancelButton = _G[self.ui:GetName().."CancelButton"] end function RecordGoldEditable.prototype:Show() RecordGoldEditable.super.prototype.Show(self) self.goldText:SetScript("OnEscapePressed",function() self:OnCancel()end) self.goldText:SetScript("OnEnterPressed",function() self:OnProceed()end) end function RecordGoldEditable.prototype:UpdateUIElements() self.goldText:SetText(self:GetRecord():GetIncome() or "") end function RecordGoldEditable.prototype:CommitRecord() local record = self:GetRecord() record:SetIncome(tonumber(self.goldText:GetText())) end local RecordItemEditable = AceOO.Class(RecordEditable) function RecordItemEditable.prototype:CreateUI(name) self.ui = _G[name] or CreateFrame("Button",name,UIParent,"GDKPItemEditableTemplate") self.descText = _G[self.ui:GetName().."DescText"] self.proceedButton = _G[self.ui:GetName().."ProceedButton"] self.cancelButton = _G[self.ui:GetName().."CancelButton"] end function RecordItemEditable.prototype:Show() RecordItemEditable.super.prototype.Show(self) self.descText:SetScript("OnEscapePressed",function() self:OnCancel()end) self.descText:SetScript("OnEnterPressed",function() self:OnProceed()end) end function RecordItemEditable.prototype:UpdateUIElements() end function RecordItemEditable.prototype:CommitRecord() local record = self:GetRecord() record:SetDesc(self.descText:GetText()) end local RecordExpenseEditable = AceOO.Class(RecordEditable) local function GDKP_30f6a7528cc97c85af9bc52925a2f83d(editBox) editBox:EnableMouse(false) editBox:ClearFocus(); editBox:SetAlpha(0.4) end local function GDKP_677ceb47d1bdfbe2b0ac9ad23bf62a82(editBox) editBox:EnableMouse(true) editBox:SetFocus(); editBox:SetAlpha(1) end function RecordExpenseEditable.prototype:CreateUI(name) self.ui = _G[name] or CreateFrame("Button",name,UIParent,"GDKPExpenseEditableTemplate") self.goldText = _G[self.ui:GetName().."GoldText"] self.generalCheck = _G[self.ui:GetName().."GeneralCheck"] _G[self.generalCheck:GetName().."Text"]:SetText("一般支出") self.tankCheck = _G[self.ui:GetName().."TankCheck"] _G[self.tankCheck:GetName().."Text"]:SetText("坦克补助") self.healerCheck = _G[self.ui:GetName().."HealerCheck"] _G[self.healerCheck:GetName().."Text"]:SetText("治疗补助") self.descText = _G[self.ui:GetName().."DescText"] self.generalCheck:SetScript("OnClick",function() self.generalCheck:SetChecked(1) self.tankCheck:SetChecked(nil) self.healerCheck:SetChecked(nil) GDKP_677ceb47d1bdfbe2b0ac9ad23bf62a82(self.descText) end) self.tankCheck:SetScript("OnClick",function() self.generalCheck:SetChecked(nil) self.tankCheck:SetChecked(1) self.healerCheck:SetChecked(nil) GDKP_30f6a7528cc97c85af9bc52925a2f83d(self.descText) end) self.healerCheck:SetScript("OnClick",function() self.generalCheck:SetChecked(nil) self.tankCheck:SetChecked(nil) self.healerCheck:SetChecked(1) GDKP_30f6a7528cc97c85af9bc52925a2f83d(self.descText) end) self.goldText:SetScript("OnTabPressed",function() if self.generalCheck:GetChecked() then self.descText:SetFocus(); end end) self.descText:SetScript("OnTabPressed",function() self.goldText:SetFocus(); end) self.proceedButton = _G[self.ui:GetName().."ProceedButton"] self.cancelButton = _G[self.ui:GetName().."CancelButton"] end function RecordExpenseEditable.prototype:Show() RecordExpenseEditable.super.prototype.Show(self) self.goldText:SetScript("OnEscapePressed",function() self:OnCancel()end) self.goldText:SetScript("OnEnterPressed",function() self:OnProceed()end) self.descText:SetScript("OnEscapePressed",function() self:OnCancel()end) self.descText:SetScript("OnEnterPressed",function() self:OnProceed()end) self.goldText:SetFocus(); end function RecordExpenseEditable.prototype:UpdateUIElements() self.goldText:SetText(self:GetRecord():GetExpense() or "") local expType = self:GetRecord():GetExpenseType() if expType == 1 then self.generalCheck:SetChecked(1) self.tankCheck:SetChecked(nil) self.healerCheck:SetChecked(nil) GDKP_677ceb47d1bdfbe2b0ac9ad23bf62a82(self.descText) elseif expType==2 then self.generalCheck:SetChecked(nil) self.tankCheck:SetChecked(1) self.healerCheck:SetChecked(nil) GDKP_30f6a7528cc97c85af9bc52925a2f83d(self.descText) elseif expType==3 then self.generalCheck:SetChecked(nil) self.tankCheck:SetChecked(nil) self.healerCheck:SetChecked(1) GDKP_30f6a7528cc97c85af9bc52925a2f83d(self.descText) else self.generalCheck:SetChecked(1) self.tankCheck:SetChecked(nil) self.healerCheck:SetChecked(nil) GDKP_677ceb47d1bdfbe2b0ac9ad23bf62a82(self.descText) end end function RecordExpenseEditable.prototype:CommitRecord() local record = self:GetRecord() record:SetDesc(self.descText:GetText()) record:SetExpense(tonumber(self.goldText:GetText())) if self.generalCheck:GetChecked() then record:SetExpenseType(1) elseif self.tankCheck:GetChecked() then record:SetExpenseType(2) elseif self.healerCheck:GetChecked() then record:SetExpenseType(3) end end local Cell = AceOO.Class(RecordUI) Cell.virtual = true local GDKP_CELL_HLNAMES={ "HighlightTopLeft", "HighlightTopRight", "HighlightBottomLeft", "HighlightBottomRight", "HighlightTop", "HighlightBottom", "HighlightLeft", "HighlightRight", } local GDKP_CELL_HLCOORD={ {left = 0, right = 0.03515625 , top = 0, bottom = 0.140625}, {left = 0.02734375, right = 0.0625 , top = 0.4375, bottom = 0.578125}, {left = 0, right = 0.03515625 , top = 0.265625, bottom = 0.40625}, {left = 0.02734375, right = 0.0625 , top = 0.703125, bottom = 0.84375}, {left = 0.046875, right = 0.08203125 , top = 0, bottom = 0.140625}, {left = 0.046875, right = 0.08203125 , top = 0.265625, bottom = 0.40625}, {left = 0, right = 0.03515625 , top = 0.1875, bottom = 0.234375}, {left = 0.02734375, right = 0.0625 , top = 0.625, bottom = 0.671875}, } function Cell.prototype:CreateHighlight() local textureTable = {} for i,val in ipairs(GDKP_CELL_HLNAMES) do local texture = self.ui:CreateTexture(self.ui:GetName()..val,"OVERLAY") texture:SetTexture([[Interface\PaperDollInfoFrame\UI-Character-ReputationBar-Highlight]]) texture:SetTexCoord(GDKP_CELL_HLCOORD[i].left, GDKP_CELL_HLCOORD[i].right, GDKP_CELL_HLCOORD[i].top, GDKP_CELL_HLCOORD[i].bottom) texture:SetBlendMode("ADD") texture:SetWidth(10) texture:SetHeight(10) texture:Hide() tinsert(textureTable,texture) end textureTable[1]:SetPoint("TOPLEFT",self.ui,"TOPLEFT",0,0) textureTable[2]:SetPoint("TOPRIGHT",self.ui,"TOPRIGHT",0,0) textureTable[3]:SetPoint("BOTTOMLEFT",self.ui,"BOTTOMLEFT",0,0) textureTable[4]:SetPoint("BOTTOMRIGHT",self.ui,"BOTTOMRIGHT",0,0) textureTable[5]:SetPoint("TOPLEFT",_G[self.ui:GetName().."HighlightTopLeft"],"TOPRIGHT",0,0) textureTable[5]:SetPoint("BOTTOMRIGHT",_G[self.ui:GetName().."HighlightTopRight"],"BOTTOMLEFT",0,0) textureTable[6]:SetPoint("TOPLEFT",_G[self.ui:GetName().."HighlightBottomLeft"],"TOPRIGHT",0,0) textureTable[6]:SetPoint("BOTTOMRIGHT",_G[self.ui:GetName().."HighlightBottomRight"],"BOTTOMLEFT",0,0) textureTable[7]:SetPoint("TOPLEFT",_G[self.ui:GetName().."HighlightTopLeft"],"BOTTOMLEFT",0,0) textureTable[7]:SetPoint("BOTTOMRIGHT",_G[self.ui:GetName().."HighlightBottomLeft"],"TOPRIGHT",0,0) textureTable[8]:SetPoint("TOPLEFT",_G[self.ui:GetName().."HighlightTopRight"],"BOTTOMLEFT",0,0) textureTable[8]:SetPoint("BOTTOMRIGHT",_G[self.ui:GetName().."HighlightBottomRight"],"TOPRIGHT",0,0) self.borderTextures = textureTable end function Cell.prototype:ShowBorder() end function Cell.prototype:HideBorder() for _,val in pairs(self.borderTextures) do val:Hide() end end function Cell.prototype:HighlightBorder() for _,val in pairs(self.borderTextures) do val:SetAlpha(1) val:Show() end end function Cell.prototype:GetPanel() return self.panel end function Cell.prototype:SetPanel(...) self.panel = ... end function Cell.prototype:init(name,record) Cell.super.prototype.init(self,name,record) self:CreateHighlight() self:SetScript("OnEnter",function() if self:GetPanel():GetSelectedRecord() ==self:GetRecord() then self:HighlightBorder() else self:ShowBorder() end end) self:SetScript("OnLeave",function() if self:GetPanel():GetSelectedRecord() ==self:GetRecord() then self:HighlightBorder() else self:HideBorder() end end) end local LogCell = AceOO.Class(Cell) function LogCell.prototype:CreateUI(name) self.ui = _G[name] or CreateFrame("CheckButton",name,UIParent,"GDKPLogCellTemplate") self.timeText = _G[self.ui:GetName().."CTimeText"] self.descText = _G[self.ui:GetName().."DescText"] self.incomeText = _G[self.ui:GetName().."IncomeText"] self.expenseText = _G[self.ui:GetName().."ExpenseText"] end function LogCell.prototype:UpdateUIElements() self.timeText:SetText(date(dateFormat,self:GetRecord():GetCTime())) self.descText:SetText(self:GetRecord():GetDesc()) self.incomeText:SetText(self:GetRecord():GetIncome() or "/") self.expenseText:SetText(self:GetRecord():GetExpense() or "/") end local IncomeCell = AceOO.Class(Cell) function IncomeCell.prototype:CreateUI(name) self.ui = _G[name] or CreateFrame("CheckButton",name,UIParent,"GDKPIncomeCellTemplate") self.timeText = _G[self.ui:GetName().."CTimeText"] self.descText = _G[self.ui:GetName().."DescText"] self.incomeText = _G[self.ui:GetName().."IncomeText"] self.unitText = _G[self.ui:GetName().."UnitText"] self.editButton = _G[self.ui:GetName().."EditButton"] self.deleteButton = _G[self.ui:GetName().."DeleteButton"] self.editable = RecordGoldEditable:new("RecordGoldEditableUI") end function IncomeCell.prototype:UpdateUIElements() self.timeText:SetText(date(dateFormat,self:GetRecord():GetCTime())) self.descText:SetText(self:GetRecord():GetItem() or self:GetRecord():GetDesc()) self.incomeText:SetText(self:GetRecord():GetIncome() or "0") self.unitText:SetText(self:GetRecord():GetUnit() or "") end local ExpenseCell = AceOO.Class(Cell) function ExpenseCell.prototype:CreateUI(name) self.ui = _G[name] or CreateFrame("CheckButton",name,UIParent,"GDKPExpenseCellTemplate") self.timeText = _G[self.ui:GetName().."CTimeText"] self.descText = _G[self.ui:GetName().."DescText"] self.expenseText = _G[self.ui:GetName().."ExpenseText"] self.editButton = _G[self.ui:GetName().."EditButton"] self.deleteButton = _G[self.ui:GetName().."DeleteButton"] self.editable = RecordExpenseEditable:new("RecordExpenseEditableUI") end function ExpenseCell.prototype:UpdateUIElements() self.timeText:SetText(date(dateFormat,self:GetRecord():GetCTime())) self.descText:SetText(self:GetRecord():GetDesc()) self.expenseText:SetText(self:GetRecord():GetExpense() or "/") end local NewIncomeCell = AceOO.Class(Cell) function NewIncomeCell.prototype:CreateUI(name) self.ui = _G[name] or CreateFrame("CheckButton",name,UIParent,"GDKPNewIncomeCellTemplate") self.timeText = _G[self.ui:GetName().."CTimeText"] self.descText = _G[self.ui:GetName().."DescText"] self.incomeText = _G[self.ui:GetName().."IncomeText"] self.unitText = _G[self.ui:GetName().."UnitText"] self.editButton = _G[self.ui:GetName().."EditButton"] self.deleteButton = _G[self.ui:GetName().."DeleteButton"] self.editable = RecordGoldEditable:new("RecordGoldEditableUI") end function NewIncomeCell.prototype:UpdateUIElements() self.timeText:SetText(date(dateFormat,self:GetRecord():GetCTime())) self.descText:SetText(self:GetRecord():GetItem() or self:GetRecord():GetDesc()) self.incomeText:SetText(self:GetRecord():GetIncome() or "0") self.unitText:SetText(self:GetRecord():GetUnit() or "") end local Panel = AceOO.Class(UIObject) function Panel.prototype:init(cType,size,width,height) Panel.super.prototype.init(self) local cell,prefix local template = T.Templates[cType.."Cell"] self.records = self.records or {} self.cells = {} self.headers = {} self.type = cType self.ui = _G["GDKPPanel"..cType] or CreateFrame("Frame","GDKPPanel"..cType,UIParent,"GDKPTabTemplate") self:SetWidth(width) self:SetHeight(height) for i = 1, size do prefix = "GDKPPanelCell"..cType..i cell = template:new(prefix) cell:SetParent(self.ui) cell:ClearAllPoints() cell:SetPanel(self) cell:RegisterForClicks("LeftButtonUp") cell:SetScript("OnClick",function(frame) self:SetSelectedRecord(frame.object:GetRecord()) self:UpdateBorders() end) if i == 1 then cell:SetPoint("TOPLEFT",self.ui,"TOPLEFT",0,-28) else cell:SetPoint("TOP",self.cells[i-1].ui,"BOTTOM",0,0) end tinsert(self.cells,cell) end self.scrollFrame = _G[self.ui:GetName().."ScrollFrame"] or CreateFrame("ScrollFrame",self.ui:GetName().."ScrollFrame",self.ui,"FauxScrollFrameTemplate") self.scrollFrame:EnableMouseWheel(true) self.scrollFrame:SetPoint("TOPRIGHT",self.ui,"TOPRIGHT",-8,-3) self.scrollFrame:SetWidth(width) self.scrollFrame:SetHeight(height*1.66) self.scrollFrame:Hide() self.scrollFrame:SetScale(0.6) self.scrollFrame:SetScript("OnVerticalScroll",function (ui,offset) FauxScrollFrame_OnVerticalScroll(ui, offset, 200, function(scroll) local offset = FauxScrollFrame_GetOffset(ui) self:UpdatePanel(offset) end) end) end function Panel.prototype:AddRecord(record) table.insert(self.records,record) self:UpdatePanel() end function Panel.prototype:SetRecordList(list) self.records={} for i = 1, #list do table.insert(self.records,list[i]) end self:UpdatePanel() end function Panel.prototype:AddHeader(name,width,callback) local headerUI headerUI = _G[self.ui:GetName().."Header"..(#self.headers+1)] or CreateFrame("Button",self.ui:GetName().."Header"..(#self.headers+1),self.ui,"GDKPColumnHeaderTemplate") headerUI:RegisterForClicks("LeftButtonUp") headerUI:SetScript("OnClick",function() if callback then callback(self) end end) _G[headerUI:GetName().."Name"]:SetText(name) headerUI:SetWidth(width) tinsert(self.headers,headerUI) end function Panel.prototype:ShowHeaders() local header for i = 1, #self.headers do if not header then self.headers[i]:SetPoint("TOPLEFT",self.ui,"TOPLEFT") else self.headers[i]:SetPoint("LEFT",header,"RIGHT",-1,0) end header = self.headers[i] end end function Panel.prototype:DeleteRecord(...) local record = ... if type(record)=="table" then for i = 1,#self.records do if record ==self.records[i] then tremove(self.records,i) end end elseif type(record)=="number" then tremove(self.records,record) end self:UpdatePanel() end function Panel.prototype:SetFilter(filterFunc) self.filterFunc = filterFunc end function Panel.prototype:SetSort(sortFunc) self.sortFunc = sortFunc end function Panel.prototype:UpdatePanel(offset) local tempTable = {} offset = offset or 0 if self.filterFunc then for i = 1, #self.records do if self.filterFunc(self.records[i]) then tinsert(tempTable,self.records[i]) end end else tempTable = self.records end if self.sortFunc then table.sort(tempTable,self.sortFunc) end for i = 1, #self.cells do if tempTable[i + offset] then self.cells[i]:SetRecord(tempTable[i + offset]) else self.cells[i]:ClearRecord() end self.cells[i]:Update() end self:UpdateBorders() FauxScrollFrame_Update(self.scrollFrame,#tempTable,#self.cells,200) end function Panel.prototype:SetSelectedRecord(record) self.currentRecord = record end function Panel.prototype:GetSelectedRecord() return self.currentRecord end function Panel.prototype:UpdateBorders() for i = 1, #self.cells do if self:GetSelectedRecord() == self.cells[i]:GetRecord() then self.cells[i]:HighlightBorder() else self.cells[i]:HideBorder() end end end function Panel.prototype:SetEditCallback(callback) local cell for i = 1 ,#self.cells do cell = self.cells[i] cell:SetEditableCallback(callback) end end function Panel.prototype:SetDeleteCallback(callback) local cell for i = 1 ,#self.cells do cell = self.cells[i] cell:SetDeleteCallback(callback) end end function Panel.prototype:SetNewCallback(callback) if self.editable then self.editable:SetCommitCallback(callback) end end function Panel.prototype:SetShowCallback(callback) self:SetScript("OnShow",function() pcall(callback,self) end) end local function GDKP_9499c7cde630463f81b4bad04f2d698b(self) self.editable = RecordItemEditable:new("RecordItemEditableUI") self.desc = self.ui:CreateFontString(self.ui:GetName().."NewIncomDesc","OVERLAY","GDKPFontSmallDisable") self.desc:SetPoint("TOPLEFT",self.ui,"BOTTOMLEFT",10,-4) self.desc:SetWidth(400) self.desc:SetHeight(20) self.desc:SetJustifyH("LEFT") self.desc:SetText(GDKP_TEXT_NEWINCOM_NEWITEM_DESC) self.addButton = BLibrary("BFButton", self.ui, 100, 25); self.addButton:SetPoint("TOPRIGHT",self.ui,"BOTTOMRIGHT",-10,-2) self.addButton:SetText("增加收入") self.addButton.OnClick = function() local record = SpecialIncomeRecord:new({}) self.editable:SetRecord(record) self.editable:SetPoint("BOTTOMLEFT",self.ui,"BOTTOMRIGHT",0,0) self.editable:Update() self.editable:Show() end end local function GDKP_1ee78db51271f3231b574ae101c13be1(self) self.editable = RecordExpenseEditable:new("RecordExpenseEditableUI") self.desc = self.ui:CreateFontString(self.ui:GetName().."NewExpenseDesc","OVERLAY","GDKPFontSmallDisable") self.desc:SetPoint("TOPLEFT",self.ui,"BOTTOMLEFT",10,-4) self.desc:SetWidth(400) self.desc:SetHeight(20) self.desc:SetJustifyH("LEFT") self.desc:SetText(GDKP_TEXT_NEWIEXPENSE_NEWITEM_DESC) self.addButton = BLibrary("BFButton", self.ui, 100, 25); self.addButton:SetPoint("TOPRIGHT",self.ui,"BOTTOMRIGHT",-10,-2) self.addButton:SetText("增加支出"); self.addButton.OnClick = function() local record = ExpenseRecord:new({}) self.editable:SetRecord(record) self.editable:SetPoint("BOTTOMLEFT",self.ui,"BOTTOMRIGHT",0,0) self.editable:Update() self.editable:Show() end end local function GDKP_091db6bdbe084b5a3f779bb06a381b68(panel) if panel.ascTime then panel:SetSort(function(r1,r2) if not r1 then return false end if not r2 then return true end return r1:GetCTime() > r2:GetCTime() end) else panel:SetSort(function(r2,r1) if not r1 then return false end if not r2 then return true end return r1:GetCTime() > r2:GetCTime() end) end panel.ascTime = not panel.ascTime panel:UpdatePanel() end local function GDKP_cdc6fdceabbb1b942f6913943bfaf69e(self) if self.ascDesc then self:SetSort(function(r1,r2) if not r1 then return false end if not r2 then return true end return ( r1:GetDesc() or "")> (r2:GetDesc() or "") end) else self:SetSort(function(r2,r1) if not r1 then return false end if not r2 then return true end return ( r1:GetDesc() or "")> (r2:GetDesc() or "") end) end self.ascDesc = not self.ascDesc self:UpdatePanel() end local function GDKP_7754b0b9a9996654acad765bbf51dd9e(self) if self.ascExpense then self:SetSort(function(r1,r2) if not r1 then return false end if not r2 then return true end return tonumber(r1:GetExpense() or "0")> tonumber(r2:GetExpense() or "0") end) else self:SetSort(function(r2,r1) if not r1 then return false end if not r2 then return true end return tonumber(r1:GetExpense() or "0")> tonumber(r2:GetExpense() or "0") end) end self.ascExpense = not self.ascExpense self:UpdatePanel() end local function GDKP_e3f3c3b8bf9940556206fc19d995ec8c(self) if self.ascUnit then self:SetSort(function(r1,r2) if not r1 then return false end if not r2 then return true end return (r1:GetUnit() or "")> (r2:GetUnit() or "") end) else self:SetSort(function(r2,r1) if not r1 then return false end if not r2 then return true end return (r1:GetUnit() or "")> (r2:GetUnit() or "") end) end self.ascUnit = not self.ascUnit self:UpdatePanel() end local function GDKP_c27e88cdd34b5ab9e91467525de85cc2(self) if self.ascIncome then self:SetSort(function(r1,r2) if not r1 then return false end if not r2 then return true end return tonumber(r1:GetIncome() or "0")> tonumber(r2:GetIncome() or "0") end) else self:SetSort(function(r2,r1) if not r1 then return false end if not r2 then return true end return tonumber(r1:GetIncome() or "0")> tonumber(r2:GetIncome() or "0") end) end self.ascIncome = not self.ascIncome self:UpdatePanel() end local function GDKP_6723107b5abc6abf92547692fa00a287(self) if self.ascName then self:SetSort(function(r1,r2) if not r1 then return false end if not r2 then return true end return (r1:GetItem() or r1:GetDesc() or "")> (r2:GetItem() or r2:GetDesc() or "") end) else self:SetSort(function(r2,r1) if not r1 then return false end if not r2 then return true end return (r1:GetItem() or r1:GetDesc() or "")> (r2:GetItem() or r2:GetDesc() or "") end) end self.ascName = not self.ascName self:UpdatePanel() end local LogPanel = AceOO.Class(Panel) function LogPanel.prototype:init() LogPanel.super.prototype.init(self,"Log",8,452,335) self:AddHeader("时间",80,GDKP_091db6bdbe084b5a3f779bb06a381b68) self:AddHeader("日志内容",220,GDKP_cdc6fdceabbb1b942f6913943bfaf69e) self:AddHeader("收入",80,GDKP_c27e88cdd34b5ab9e91467525de85cc2) self:AddHeader("支出",80,GDKP_7754b0b9a9996654acad765bbf51dd9e) self:ShowHeaders() end local NewIncomePanel = AceOO.Class(Panel) function NewIncomePanel.prototype:init() NewIncomePanel.super.prototype.init(self,"NewIncome",6,452,268) self:AddHeader("时间",60,GDKP_091db6bdbe084b5a3f779bb06a381b68) self:AddHeader("收入名称",160,GDKP_6723107b5abc6abf92547692fa00a287) self:AddHeader("拾取人",90,GDKP_e3f3c3b8bf9940556206fc19d995ec8c) self:AddHeader("收入/修改",90,GDKP_c27e88cdd34b5ab9e91467525de85cc2) self:AddHeader("删除",55) self:ShowHeaders() GDKP_9499c7cde630463f81b4bad04f2d698b(self) end local IncomePanel = AceOO.Class(Panel) function IncomePanel.prototype:init() IncomePanel.super.prototype.init(self,"Income",7,452,310) self:AddHeader("时间",60,GDKP_091db6bdbe084b5a3f779bb06a381b68) self:AddHeader("收入名称",160,GDKP_6723107b5abc6abf92547692fa00a287) self:AddHeader("拾取人",90,GDKP_e3f3c3b8bf9940556206fc19d995ec8c) self:AddHeader("收入/修改",90,GDKP_c27e88cdd34b5ab9e91467525de85cc2) self:AddHeader("删除",55) self:ShowHeaders() GDKP_9499c7cde630463f81b4bad04f2d698b(self) end local ExpensePanel = AceOO.Class(Panel) function ExpensePanel.prototype:init() ExpensePanel.super.prototype.init(self,"Expense",7,452,310) self:AddHeader("时间",80,GDKP_091db6bdbe084b5a3f779bb06a381b68) self:AddHeader("支出名称",200,GDKP_cdc6fdceabbb1b942f6913943bfaf69e) self:AddHeader("支出",60,GDKP_7754b0b9a9996654acad765bbf51dd9e) self:AddHeader("编辑",60) self:AddHeader("删除",55) self:ShowHeaders() GDKP_1ee78db51271f3231b574ae101c13be1(self) end T.Templates.NormalItemRecord = NormalItemRecord T.Templates.SpecialIncomeRecord = SpecialIncomeRecord T.Templates.ExpenseRecord = ExpenseRecord T.Templates.TrivialRecord = TrivialRecord T.Templates.Account = Account T.Templates.LogCell = LogCell T.Templates.IncomeCell = IncomeCell T.Templates.ExpenseCell = ExpenseCell T.Templates.NewIncomeCell = NewIncomeCell T.Templates.RecordExpenseEditable = RecordExpenseEditable T.Templates.RecordItemEditable = RecordItemEditable T.Templates.RecordGoldEditable = RecordGoldEditable T.Templates.Panel = Panel T.Templates.NewIncomePanel = NewIncomePanel T.Templates.IncomePanel = IncomePanel T.Templates.LogPanel = LogPanel T.Templates.ExpensePanel = ExpensePanel 
