
local C = LibStub("AceAddon-3.0"):GetAddon("BFTargetFrame")

local config = C.config

function C:TargetFrame_UpdateAuraPositions(...)
	local frame,auraName, numAuras, numOppositeAuras, largeAuraList, updateFunc, maxRowWidth, offsetX = ...
	local size;
	local rowWidth = 0;
	local firstBuffOnRow = 1;
	--ظۼ
	for i=1, numAuras do
		if ( largeAuraList[i] ) then
			size = config.self
		else
			size = config.other
		end

		if ( i == 1 ) then
			rowWidth = size;
		else
			rowWidth = rowWidth + size + offsetX;
		end
		if ( rowWidth > maxRowWidth ) then
			updateFunc(frame,auraName, i, numOppositeAuras, firstBuffOnRow, size, offsetX, 0);
			rowWidth = size;
			firstBuffOnRow = i;

			if ( frame.auraRows > config.row ) then
				maxRowWidth = config.rowWidth;
			end
		else
			updateFunc(frame,auraName, i, numOppositeAuras, i - 1, size, offsetX, 0);
		end
	end
end

function C:OnEnable()
	C:SecureHook("TargetFrame_UpdateAuraPositions")
end


function C:OnDisable()
end